/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileOutputStream
extends OutputStream {
    private int filePosition;
    private final RandomAccessFile raf;

    public RandomAccessFileOutputStream(RandomAccessFile raf, int startFilePosition) {
        this.filePosition = startFilePosition;
        this.raf = raf;
    }

    @Override
    public void write(int b) throws IOException {
        this.raf.seek(this.filePosition);
        ++this.filePosition;
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.raf.seek(this.filePosition);
        this.filePosition += b.length;
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.seek(this.filePosition);
        this.filePosition += len;
        this.raf.write(b, off, len);
    }
}

